#include <algorithm>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <set>
#include <map>
#include <iterator>
#include <cmath>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cctype>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define ROF(i, a, b) for (int i = (b) - 1; i >= (a); --i)

typedef pair <int, int> pii;
typedef long long LL;
typedef LL ll;

const int INF = 1000000000;
const LL LINF = (LL) INF * (LL) INF;

const int kN = 1 << 17;

struct SegmentTree {
  int data[2 * kN - 1];

  SegmentTree() {
    Init();
  }

  void Init() {
    memset(data, 0, sizeof(data));
  }

  int L(int i) { return i * 2 + 1; }
  int R(int i) { return i * 2 + 2; }

  void Set(int pos, int x, int ind = 0, int tl = 0, int tr = kN - 1) {
    if (tl == tr) {
      data[ind] = x;
      return;
    }
    int tm = (tl + tr) >> 1;
    if (pos <= tm)
      Set(pos, x, L(ind), tl, tm);
    else
      Set(pos, x, R(ind), tm + 1, tr);
    data[ind] = max(data[L(ind)], data[R(ind)]);
  }

  int RMQ(int l, int r, int ind = 0, int tl = 0, int tr = kN - 1) {
    if (l == tl && r == tr) {
      return data[ind];
    }
    int tm = (tl + tr) >> 1;
    if (r <= tm)
      return RMQ(l, r, L(ind), tl, tm);
    else if (tm < l)
      return RMQ(l, r, R(ind), tm + 1, tr);
    else 
      return max(RMQ(l, tm, L(ind), tl, tm), RMQ(tm + 1, r, R(ind), tm + 1, tr));
  }
};

struct Trio {
  int a, b, c;
  Trio() {}
};

bool operator < (const Trio& l, const Trio& r) {
  return l.a < r.a;
}

SegmentTree tree;

int main() {
  std::ios_base::sync_with_stdio(false);
  int test_count;
  cin >> test_count;
  for (int index = 0; index < test_count; ++index) {
    int n;
    cin >> n;
    vector<Trio> arr(n);
    for (int i = 0; i < n; ++i) {
      cin >> arr[i].a >> arr[i].b >> arr[i].c;
      arr[i].a = n - arr[i].a + 1;
      arr[i].b = n - arr[i].b + 1;
      arr[i].c = n - arr[i].c + 1;
    }
    sort(arr.rbegin(), arr.rend());
    tree.Init();
    int res = 0;
    for (int i = 0; i < n; ++i) {
      int q = tree.RMQ(arr[i].b - 1, kN - 1);
      if (q > arr[i].c) {
        ++res;
      }
      tree.Set(arr[i].b - 1, arr[i].c);
    }
    cout << n - res << '\n';
  }
  return 0;
}